#include <cstdio>
#include <cstring>
#include <algorithm>
#include <vector>

const int LG = 17;
const int N = 100000;
int n, m, in[N], out[N], up[LG][N], pr[N];
bool u[N], need[N], vis[N], x[N];
std::vector<std::pair<int, int> > edg;
std::vector<int> g[N], g1[N], all;
bool ok = 1;

void dfs(int v) {
	static int dt = 0;
	in[v] = dt++;
	u[v] = 1;
	for (int i = 0; i < (int)g[v].size(); ++i) if (g[v][i] != up[0][v]) {
		if (u[g[v][i]]) {
			if (!out[g[v][i]]) {
				edg.push_back(std::make_pair(v, g[v][i]));
				need[v] = 1;
				need[g[v][i]] = 1;
			}
		} else {
			up[0][g[v][i]] = v;
			dfs(g[v][i]);
		}
	}
	if (g[v].size() == 1 && g[v].front() == up[0][v]) ok = 0;
	out[v] = dt;
}

bool par(int u, int v) {
	return in[u] <= in[v] && out[u] >= out[v];
}

int lca(int u, int v) {
	if (par(u, v)) return u;
	for (int i = LG - 1; i >= 0; --i) if (!par(up[i][u], v)) u = up[i][u];
	return up[0][u];
}

void add_edge(int a, int b) {
	g1[a].push_back(b);
	g1[b].push_back(a);
}

void rm_edge(int a, int b) {
	g1[a].pop_back();
	g1[b].pop_back();
}

void xpath(int v) {
	while (v) {
		x[v] ^= 1;
		v = pr[v];
	}
}

bool isedg(int a, int b) {
	if (pr[a] != b) std::swap(a, b);
	if (pr[a] != b) return 1;
	return x[a];
}

int len;
bool test(int v) {
	vis[v] = 1;
	++len;
	for (int i = 0; i < (int)g1[v].size(); ++i) if (isedg(v, g1[v][i])) {
		if (!g1[v][i] && len == (int)all.size()) return 1;
		if (!vis[g1[v][i]]) return test(g1[v][i]);
	}
	return 0;
}

int ans = 0;
bool run(int ind, int mask) {
	if (ind == (int)edg.size()) {
		len = 0;
		for (int i = 0; i < (int)all.size(); ++i) vis[all[i]] = 0;
		if (test(0)) {
			ans = mask;
			return 1;
		}
		return 0;
	}
	if (run(ind + 1, mask)) return 1;
	if (pr[edg[ind].first] == edg[ind].second || pr[edg[ind].second] == edg[ind].first) return 0;
	xpath(edg[ind].first);
	xpath(edg[ind].second);
	add_edge(edg[ind].first, edg[ind].second);
	if (run(ind + 1, mask | 1 << ind)) return 1;
	xpath(edg[ind].first);
	xpath(edg[ind].second);
	rm_edge(edg[ind].first, edg[ind].second);
	return 0;
}

void dfsx(int v) {
	for (int i = 0; i < (int)g[v].size(); ++i) {
		dfsx(g[v][i]);
		x[v] ^= x[g[v][i]];
	}
}

bool isedg1(int a, int b) {
	if (up[0][a] != b) std::swap(a, b);
	if (up[0][a] != b) return 1;
	return x[a];
}

std::vector<int> aans;
void findans(int v) {
	vis[v] = 1;
	aans.push_back(v);
	for (int i = 0; i < (int)g[v].size(); ++i) if (isedg1(v, g[v][i]) && !vis[g[v][i]]) {
		findans(g[v][i]);
		return;
	}
}

int main() {
	scanf("%d%d", &n, &m);
	for (int i = 0; i < m; ++i) {
		int a, b;
		scanf("%d%d", &a, &b);
		g[a - 1].push_back(b - 1);
		g[b - 1].push_back(a - 1);
	}
	dfs(0);
	for (int j = 1; j < LG; ++j) for (int i = 0; i < n; ++i) up[j][i] = up[j - 1][up[j - 1][i]];
	for (int i = 0; i < n; ++i) if (!u[i]) ok = 0;
	if (!ok) {
		printf("0\n");
		return 0;
	}
	std::vector<std::pair<int, int> > vec;
	need[0] = 1;
	for (int i = 0; i < n; ++i) if (need[i]) vec.push_back(std::make_pair(in[i], i));
	std::sort(vec.begin(), vec.end());
	std::vector<int> st;
	st.push_back(0);
	vec.push_back(std::make_pair(0, 0));
	all.push_back(0);
	for (int i = 1; i < (int)vec.size(); ++i) {
		int l = lca(vec[i].second, st.back());
		while (st.back() != l && par(l, st.back())) {
			all.push_back(st.back());
			if (par(st[(int)st.size() - 2], l)) pr[st.back()] = l;
			else pr[st.back()] = st[(int)st.size() - 2];
			add_edge(st.back(), pr[st.back()]);
			st.pop_back();
		}
		if (st.back() != l) st.push_back(l);
		if (st.back() != vec[i].second) st.push_back(vec[i].second);
	}
	std::sort(all.begin(), all.end());
	all.resize(std::unique(all.begin(), all.end()) - all.begin());
	if (run(0, 0)) {
		memset(x, 0, n);
		memset(vis, 0, n);
		printf("YES\n");
		for (int i = 0; i < n; ++i) g[i].clear();
		for (int i = 1; i < n; ++i) g[up[0][i]].push_back(i);
		for (int i = 0; i < (int)edg.size(); ++i) if (ans >> i & 1) {
			x[edg[i].first] ^= 1;
			x[edg[i].second] ^= 1;
		}
		dfsx(0);
		for (int i = 0; i < (int)edg.size(); ++i) if (ans >> i & 1) {
			g[edg[i].first].push_back(edg[i].second);
			g[edg[i].second].push_back(edg[i].first);
		}
		for (int i = 1; i < n; ++i) g[i].push_back(up[0][i]);
		findans(0);
		for (int i = 0; i < (int)aans.size(); ++i) printf("%d ", aans[i] + 1);
		printf("1\n");
	} else printf("NO\n");
	return 0;
}